/*
 * Die Sourcecodes, die diesem Buch als Beispiele beiliegen, sind
 * Copyright (c) 2006 - Thomas Ekert. Alle Rechte vorbehalten.
 * 
 * Trotz sorgfltiger Kontrolle sind Fehler in Softwareprodukten nie vollstndig auszuschlieen.
 * Die Sourcodes werden in Ihrem Originalzustand ausgeliefert.
 * Ansprche auf Anpassung, Weiterentwicklung, Fehlerbehebung, Support
 * oder sonstige wie auch immer gearteten Leistungen oder Haftung sind ausgeschlossen.
 * Sie drfen kommerziell genutzt, weiterverarbeitet oder weitervertrieben werden.
 * Voraussetzung hierfr ist, dass fr jeden beteiligten Entwickler, jeweils mindestens
 * ein Exemplar dieses Buches in seiner aktuellen Version als gekauftes Exemplar vorliegt.
 */
package djbuch.kapitel_13; import java.sql.*;

import djbuch.kapitel_06.DemoTools;


/** 
 * Ldt einen Notes View, der als DAV (DB2AccessView) in der DB2 Datenbank zur Verfgung
 * gestellt wurde unter Benutzung von SQL ohne den Einsatz von Domino Techniken.
 * Kann mit verschiedenen Datentypen umgehen.
 *
 *  * @author Thomas Ekert
 *
 */
public class Db2AccessView {
	
	private static final String db2Url= "jdbc:db2://localhost:50000/DOMINO";
	private static final String PASSWORD = "geheim";
	private static final String USER = "db2admin";
	private static final String SCHEMA = "VDB2_ACCESS";

	
	/** Array mit den (im ursprnglichen NotesView) definierten
	 * Datentypen und Feldnamen.
	 * Anhand der Klasse Column, kann jedem Feldnamen ein Datentyp zugeordnet werden.
	 */
	private static final Column [] COLUMNS = {
			new Column ("#NOTEID",Column.TYPE_STRING),
			new Column ("F_TITEL",Column.TYPE_STRING),
			new Column ("F_DATUM",Column.TYPE_DATE),
			new Column ("F_DATUM_LISTE",Column.TYPE_DATELIST),
			new Column ("F_NAME",Column.TYPE_STRING),
			new Column ("F_NAME_LISTE",Column.TYPE_STRING),
			new Column ("F_PASSWORT",Column.TYPE_STRING),
			new Column ("F_TEXT",Column.TYPE_STRING),
			new Column ("F_TEXT_LISTE",Column.TYPE_STRING),
			new Column ("F_TITEL",Column.TYPE_STRING),
			new Column ("F_ZAHL",Column.TYPE_LONG),
			new Column ("F_ZAHL_LISTE",Column.TYPE_LONGLIST),
			new Column ("FORM",Column.TYPE_STRING)
	};
	
	public static void main(String[] args) {
		Connection con=null;
		Statement stmt=null;
		try {
			Class.forName("com.ibm.db2.jcc.DB2Driver");
			con = DriverManager.getConnection(
					db2Url,
					USER,
					PASSWORD );
			stmt = con.createStatement();
			String query = "SELECT" + generateColumnSQL() +
					"FROM DJBUCHDB2.VDB2_ACCESS AS VDB2_ACCESS";
			//Query anzeigen
			System.out.println (query);
			//SELECT ausfhren
			ResultSet result = stmt.executeQuery(query);
			//Ergebnis anzeigen
			int marker=0;
			while (result.next()) {
				printColumns (result,marker++);
			}
			//Neue Zeile einfgen
			stmt = con.createStatement();
			stmt.executeUpdate(generateRandomInsertSQL());
		} catch (ClassNotFoundException e) {
			e.printStackTrace();
		} catch (SQLException e) {
			e.printStackTrace();
		} finally {
				try {
					if (stmt!=null) { stmt.close(); }
					if (con!=null){ con.close(); }
				} catch (SQLException e1) {
					e1.printStackTrace();
				}
		}
	}
	
	/**
	 * @param result
	 * @throws SQLException
	 */
	private static void printColumns(ResultSet result, int marker) throws SQLException {
		StringBuffer res=new StringBuffer();
		res.append ("=== row ").append (marker).append (" =========\n");
		for (int i = 0; i < COLUMNS.length;i++) {
			switch (COLUMNS[i].getType()) {
				case (Column.TYPE_STRING): 
				case (Column.TYPE_DATELIST): 
				case (Column.TYPE_LONGLIST): 
					String val = result.getString(COLUMNS [i].getName());
					if (val==null) {break;}
					String[] arr = val.split(";");
					for (int j = 0; j < arr.length; j++) {
						res.append ("\t").append (COLUMNS [i].getName()).append ("(").append(j).append("): ")
						.append (arr[j]).append("\n");
					}
					break;
				case (Column.TYPE_DATE):
					java.sql.Date dt = result.getDate(COLUMNS [i].getName());
					if (dt==null) {break;}
					res.append ("\t").append (COLUMNS [i].getName()).append ("(0): ")
					.append (dt.toString()).append("\n");
					break;
				case (Column.TYPE_LONG): 
					long l = result.getLong(COLUMNS [i].getName());
					res.append ("\t").append (COLUMNS [i].getName()).append ("(0): ")
					.append (l).append("\n");
					break;
				default: 
					break;
			}
		}
		System.out.println (res.toString());
	}

	/**
	 * 
	 * @return
	 */
	private static final String generateColumnSQL () {
		StringBuffer res = new StringBuffer(" ");
		for (int i = 0; i < COLUMNS.length; i++) {
			res.append(SCHEMA).append(".").append(COLUMNS [i].getName()).append ((i<COLUMNS.length-1)?", ":"");
		}
		res.append (" ");
		return res.toString();
	}
	
	private static final String generateRandomInsertSQL() {

		return "INSERT into DJBUCHDB2.VDB2_ACCESS"
				+ "(F_Titel,F_Text,F_TEXT_LISTE,F_ZAHL_LISTE) " + "Values ('Titel - "
				+ DemoTools.getRandomString(4) + "','neuer Wert - "
				+ DemoTools.getRandomString(5) + "','neuer Wert - "
				+ DemoTools.getRandomString(5) + ";anderer Wert - "
				+ DemoTools.getRandomString(2) + ";noch ein Wert - "
				+ DemoTools.getRandomString(4) + "', '"
				+ DemoTools.getRandomNumber() +";"+ DemoTools.getRandomNumber() + "')";
	}
	
	private Db2AccessView () {
		//hide from public
	}
}